/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;

public class RsfUpdateableComponentInfo
implements PersistentData {
    private final int version = 0;
    private static final long serialVersionUID = 1L;
    private String id;
    private String partNumber;
    private String ecNumber;
    private int stagedLevel;
    private Date stagedDate;
    private int appliedLevel;
    private Date appliedDate;
    private int committedLevel;
    private Date committedDate;
    private static NumberFormat nf2 = NumberFormat.getInstance();
    private static NumberFormat nf3 = NumberFormat.getInstance();
    private static NumberFormat nf4 = NumberFormat.getInstance();

    public RsfUpdateableComponentInfo(UpdateableComponent uComponent) throws IllegalArgumentException {
        this.id = uComponent.getName();
        if (this.id == null || (this.ecNumber = uComponent.getECNumber()) == null) {
            throw new IllegalArgumentException();
        }
        this.stagedDate = uComponent.getStagedDate();
        this.appliedDate = uComponent.getAppliedDate();
        this.committedDate = uComponent.getCommittedDate();
        this.stagedLevel = uComponent.getStagedLevel();
        if (this.stagedLevel == -1) {
            this.stagedLevel = 0;
        }
        if ((this.appliedLevel = uComponent.getAppliedLevel()) == -1) {
            this.appliedLevel = 0;
        }
        if ((this.committedLevel = uComponent.getCommittedLevel()) == -1) {
            this.committedLevel = 0;
        }
        this.partNumber = uComponent instanceof ECStream ? ((ECStream)uComponent).getPartNumber() : "0";
    }

    public RsfUpdateableComponentInfo(String mid, String ec, String pn, int stagedLevel, Date stagedDate, int appliedLevel, Date appliedDate, int committedLevel, Date committedDate) throws IllegalArgumentException {
        if (mid == null || ec == null) {
            throw new IllegalArgumentException();
        }
        this.id = mid;
        this.partNumber = pn;
        if (this.partNumber == null) {
            this.partNumber = "0";
        }
        this.ecNumber = ec;
        this.stagedLevel = stagedLevel == -1 ? 0 : stagedLevel;
        this.stagedDate = stagedDate;
        this.appliedLevel = appliedLevel == -1 ? 0 : appliedLevel;
        this.appliedDate = appliedDate;
        this.committedLevel = committedLevel == -1 ? 0 : committedLevel;
        this.committedDate = committedDate;
    }

    public int getVersion() {
        return 0;
    }

    public String getId() {
        return this.id;
    }

    public String getEcNumber() {
        return this.ecNumber;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public int getStagedLevel() {
        return this.stagedLevel;
    }

    public Date getStagedDate() {
        return this.stagedDate;
    }

    public int getAppliedLevel() {
        return this.appliedLevel;
    }

    public Date getAppliedDate() {
        return this.appliedDate;
    }

    public int getCommittedLevel() {
        return this.committedLevel;
    }

    public Date getCommittedDate() {
        return this.committedDate;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof RsfUpdateableComponentInfo && this.id.equals(((RsfUpdateableComponentInfo)o).id) && this.partNumber.equals(((RsfUpdateableComponentInfo)o).partNumber) && this.ecNumber.equals(((RsfUpdateableComponentInfo)o).ecNumber) && this.stagedLevel == ((RsfUpdateableComponentInfo)o).stagedLevel && (this.stagedDate != null && this.stagedDate.equals(((RsfUpdateableComponentInfo)o).stagedDate) || this.stagedDate == ((RsfUpdateableComponentInfo)o).stagedDate) && this.appliedLevel == ((RsfUpdateableComponentInfo)o).appliedLevel && (this.appliedDate == ((RsfUpdateableComponentInfo)o).appliedDate || this.appliedDate != null && this.appliedDate.equals(((RsfUpdateableComponentInfo)o).appliedDate)) && this.committedLevel == ((RsfUpdateableComponentInfo)o).committedLevel && (this.committedDate == ((RsfUpdateableComponentInfo)o).committedDate || this.committedDate != null && this.committedDate.equals(((RsfUpdateableComponentInfo)o).committedDate));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static String buildDate(Date inDate) {
        if (inDate == null || inDate.getTime() == 0L) {
            return "00-00-0000 00:00:00:000";
        }
        Calendar date = null;
        UserContext userContext = UserContext.getCurrentUserContext();
        date = userContext != null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : Calendar.getInstance();
        date.setTime(inDate);
        StringBuffer buffer = new StringBuffer();
        buffer.append(nf2.format(date.get(2)));
        buffer.append("-");
        buffer.append(nf2.format(date.get(5)));
        buffer.append("-");
        buffer.append(nf4.format(date.get(1)));
        buffer.append(" ");
        buffer.append(nf2.format(date.get(11)));
        buffer.append(":");
        buffer.append(nf2.format(date.get(12)));
        buffer.append(":");
        buffer.append(nf2.format(date.get(13)));
        buffer.append(":");
        buffer.append(nf3.format(date.get(14)));
        return buffer.toString();
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer("<MI><ID>");
        buffer.append(this.id);
        buffer.append("</ID><PN>");
        if (this.partNumber != null) {
            buffer.append(this.partNumber);
        }
        buffer.append("</PN><EC>");
        buffer.append(this.ecNumber);
        buffer.append("</EC>");
        buffer.append("<STM>");
        buffer.append(this.stagedLevel);
        buffer.append("</STM><STD>");
        buffer.append(RsfUpdateableComponentInfo.buildDate(this.stagedDate));
        buffer.append("</STD>");
        buffer.append("<APM>");
        buffer.append(this.appliedLevel);
        buffer.append("</APM><APD>");
        buffer.append(RsfUpdateableComponentInfo.buildDate(this.appliedDate));
        buffer.append("</APD>");
        buffer.append("<COM>");
        buffer.append(this.committedLevel);
        buffer.append("</COM><COD>");
        buffer.append(RsfUpdateableComponentInfo.buildDate(this.committedDate));
        buffer.append("</COD>");
        buffer.append("</MI>");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(" <MI><ID>");
        buffer.append(this.id);
        buffer.append("</ID><PN>");
        if (this.partNumber != null) {
            buffer.append(this.partNumber);
        }
        buffer.append("</PN><EC>");
        buffer.append(this.ecNumber);
        buffer.append("</EC><STM>");
        buffer.append(this.stagedLevel);
        buffer.append("</STM><STD>");
        buffer.append(RsfUpdateableComponentInfo.buildDate(this.stagedDate));
        buffer.append("</STD><APM>");
        buffer.append(this.appliedLevel);
        buffer.append("</APM><APD>");
        buffer.append(RsfUpdateableComponentInfo.buildDate(this.appliedDate));
        buffer.append("</APD><COM>");
        buffer.append(this.committedLevel);
        buffer.append("</COM><COD>");
        buffer.append(RsfUpdateableComponentInfo.buildDate(this.committedDate));
        buffer.append("</COD>");
        buffer.append("</MI>\n");
        return buffer.toString();
    }

    static {
        nf2.setMinimumIntegerDigits(2);
        nf3.setMinimumIntegerDigits(3);
        nf4.setMinimumIntegerDigits(4);
        nf4.setGroupingUsed(false);
    }
}

